/*******************************************************************************
* Device      : AD18F08
* Author      :
* Version     : V0.0.1
* Date        : 20230509
* Description : PA口的输入改变中断，PA口的低优先级中断,通过PB1的翻转查看PA的低优先级中断是否产生，PB1翻转PA口产生中断,否则PA口未产生中断
* Note		  :
********************************************************************************/

/********************************INCLUDES*************************************/
#include "AD18F08.h"

__CONFIG(1,_FINTOSC_DIV1_1L     & _DBG_OFF_1L       & _LVREN_OFF_1L     & _LVR24V_1L                                                                   );
__CONFIG(2,_FLASH_CP1_OFF_2L    & _FLASH_CP0_OFF_2L & _IDIS_OFF_2L     & _CKSUM_OFF_2L  & _CBP_OFF_2L   & _RESETE_OFF_2L & _RSEL_LOW_2L & _STV_ON_2L  );
__CONFIG(3,_PSUT_2_3L           & _FCPU_4T_3L       & _WDTE_OFF_3L     & _TWDT_100_3L                                                                 );
__CONFIG(4,_OSCM_HIRC_16M_4L    & _MTPDIS_OFF_4L    & _ADCSP_ON_4L                                                                                    );




void main(void)
{
    TRISA    = 0xFF; //设置PA口为输入
    TRISB0   = 0;    //设置PB0口为输出
    TRISB1   = 0;   //设置PB1口为输出

    PAPU    = 0xFF; //关闭PA口的上拉
    PBPU    = 0xFF;	//关闭PB口的上拉

    PAPD    = 0xFF;//关闭PA口的下拉
    PBPD    = 0xFF;//关闭PB口的下拉

    PAOD    = 0x00; //关闭PA口的开漏
    PBOD    = 0x00; //关闭PB口的开漏

	GIEH  = 1;//使能高优先级总中断
    GIEL  = 1;//使能低优先级总中断
    IPEN  = 1;//高低优先级中断使能位
    PAIP  = 0;//PA口的低优先级使能位
    PAIE  = 1;//PA口的中断允许位，使能之后才可以进中断服务函数
    PAIF  = 0;//PA口的中断标志位

    PAINTMASK |=(1<<0); // 使能PA0的输入改变中断控制位
    PAINTMASK |=(1<<1); // 使能PA1的输入改变中断控制位
    PAINTMASK |=(1<<2); // 使能PA2的输入改变中断控制位
    PAINTMASK |=(1<<3); // 使能PA3的输入改变中断控制位
    PAINTMASK |=(1<<4); // 使能PA4的输入改变中断控制位
    PAINTMASK |=(1<<5); // 使能PA5的输入改变中断控制位
	while(1);

}

//高优先级中断服务函数
void interrupt ISR_h (void)
{

}

//低优先级中断服务函数
void interrupt low_priority ISR_l (void)
{
  unsigned char tmp_int;
  tmp_int = PIR2;
  if((tmp_int&0X20==0X20) && PAIE )
    {
      PAIF = 0;
      PB1  = ~PB1;//用于检测PA低优先级中断
    }

}
